﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class VisnsController : ODataController
    {

        [ODataRoute("Visns({VisnNumber})")]
        public async Task<HttpResponseMessage> Get(string VisnNumber)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Visn 
                var ppmsVisn = context.va_visnSet.FirstOrDefault(i => i.va_name.Contains(VisnNumber));
                if (ppmsVisn != null)
                {
                    var ppmsVisnsList = new List<va_visn> { ppmsVisn };
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, queryType, context);
                    return Request.CreateResponse(visns);
                }
            }
            var message = string.Format("Visn with Name: {0} not found", VisnNumber);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
   
        [ODataRoute("GetVisnByName")]
        public async Task<HttpResponseMessage> GetVisnByName([FromODataUri] string visnName)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsVisns = context.va_visnSet.Where(i => i.ppms_visnname.Contains(visnName));
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = string.Format("Visns containing name: {0} not found", visnName);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }
        
        [ODataRoute("GetVisnByNumber")]
        public async Task<HttpResponseMessage> GetVisnByNumber([FromODataUri] string visnNumber)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                var ppmsVisns = context.va_visnSet.Where(i => i.va_name.Contains(visnNumber));
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = string.Format("Visns containing Visn Number: {0} not found", visnNumber);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [ODataRoute("Visns")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Visns in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsVisns = context.va_visnSet.Where(i => i.va_name != null).Take(50);
                var ppmsVisnsList = ppmsVisns.ToList();
                if (ppmsVisnsList.Any())
                {
                    //Map Visns
                    var visns = await VisnMap.MapVisns(ppmsVisnsList, "None", context);
                    return Request.CreateResponse(visns);
                }
                var message = "Visns Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }       
    }
}